/*
 * Decompiled with CFR 0.152.
 */
package de.Whitedraco.switchbow.entity.arrow;

import de.Whitedraco.switchbow.Config.ArrowConfig;
import de.Whitedraco.switchbow.Initial;
import de.Whitedraco.switchbow.ItemInit;
import de.Whitedraco.switchbow.entity.EntityArrowBase;
import de.Whitedraco.switchbow.proxy.packets.PatricleWaterDropPacket;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IThrowableEntity;

public class EntityArrowSprinkler
extends EntityArrowBase
implements IThrowableEntity {
    public static final PropertyInteger LEVEL = PropertyInteger.func_177719_a((String)"level", (int)0, (int)15);
    private double damagesetter;

    public EntityArrowSprinkler(World worldIn) {
        super(worldIn);
        this.field_70255_ao = this.damagesetter = ArrowConfig.DamageArrowSprinkler.getDoub();
    }

    public EntityArrowSprinkler(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
        this.field_70255_ao = this.damagesetter = ArrowConfig.DamageArrowSprinkler.getDoub();
    }

    public EntityArrowSprinkler(World worldIn, EntityLivingBase shooter) {
        super(worldIn, shooter);
        this.field_70255_ao = this.damagesetter = ArrowConfig.DamageArrowSprinkler.getDoub();
    }

    @Override
    protected ItemStack func_184550_j() {
        return new ItemStack(ItemInit.ArrowSprinkler);
    }

    protected void func_184548_a(EntityLivingBase living) {
        BlockPos blockpos = living.func_180425_c().func_177984_a();
        this.extinguishFireswithNeighbor(blockpos);
        this.extinguishFireswithNeighbor(blockpos.func_177978_c());
        this.extinguishFireswithNeighbor(blockpos.func_177974_f());
        this.extinguishFireswithNeighbor(blockpos.func_177976_e());
        this.extinguishFireswithNeighbor(blockpos.func_177968_d());
        this.extinguishFireswithNeighbor(blockpos.func_177984_a());
        this.extinguishFireswithNeighbor(blockpos.func_177977_b());
        this.applyWater();
    }

    private void extinguishFires(BlockPos pos) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70170_p.func_180495_p(pos).func_177230_c() == Blocks.field_150480_ab) {
                this.field_70170_p.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            }
            if (this.field_70170_p.func_180495_p(pos).func_177230_c() == Blocks.field_150478_aa) {
                this.field_70170_p.func_175655_b(pos, true);
            }
            if (this.field_70170_p.func_180495_p(pos).func_177230_c() == Blocks.field_150353_l && this.field_70170_p.func_180495_p(pos).func_177230_c() != Blocks.field_150356_k && (Integer)this.field_70170_p.func_180495_p(pos).func_177229_b((IProperty)LEVEL) == 0) {
                this.field_70170_p.func_175656_a(pos, Blocks.field_150343_Z.func_176223_P());
            }
            for (int i = 0; i < 8; ++i) {
                Initial.network.sendToAll((IMessage)new PatricleWaterDropPacket((double)pos.func_177958_n() - 0.5 + Math.random(), (double)pos.func_177956_o() + 0.25, (double)pos.func_177952_p() - 0.5 + Math.random(), 0.0, 0.0, 0.0));
            }
        }
    }

    private void applyWater() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_72321_a(4.5, 3.0, 4.5);
        List list = this.field_70170_p.func_72872_a(EntityLivingBase.class, axisalignedbb);
        if (!list.isEmpty()) {
            for (EntityLivingBase entitylivingbase : list) {
                double d0 = this.func_70068_e((Entity)entitylivingbase);
                if (d0 < 16.0 && EntityArrowSprinkler.isWaterSensitiveEntity(entitylivingbase)) {
                    entitylivingbase.func_70097_a(DamageSource.field_76369_e, 1.0f);
                }
                if (!(d0 < 16.0) || !entitylivingbase.func_70027_ad()) continue;
                entitylivingbase.func_70066_B();
            }
        }
    }

    private static boolean isWaterSensitiveEntity(EntityLivingBase p_190544_0_) {
        return p_190544_0_ instanceof EntityEnderman || p_190544_0_ instanceof EntityBlaze;
    }

    @Override
    protected void arrowHitGround(BlockPos blockpos) {
        blockpos = blockpos.func_177984_a();
        this.extinguishFireswithNeighbor(blockpos);
        this.extinguishFireswithNeighbor(blockpos.func_177978_c());
        this.extinguishFireswithNeighbor(blockpos.func_177974_f());
        this.extinguishFireswithNeighbor(blockpos.func_177976_e());
        this.extinguishFireswithNeighbor(blockpos.func_177968_d());
        this.extinguishFireswithNeighbor(blockpos.func_177984_a());
        this.extinguishFireswithNeighbor(blockpos.func_177977_b());
        this.applyWater();
        this.func_70106_y();
    }

    private void extinguishFireswithNeighbor(BlockPos blockpos) {
        this.extinguishFires(blockpos);
        this.extinguishFires(blockpos.func_177984_a());
        this.extinguishFires(blockpos.func_177977_b());
        this.extinguishFires(blockpos.func_177978_c());
        this.extinguishFires(blockpos.func_177974_f());
        this.extinguishFires(blockpos.func_177968_d());
        this.extinguishFires(blockpos.func_177976_e());
    }

    public Entity getThrower() {
        return this.field_70250_c;
    }

    public void setThrower(Entity entity) {
        this.field_70250_c = entity;
    }
}

